#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    cin >> N;

    vector<long long> x(N), y(N);
    for(int i = 0; i < N; i++){
        cin >> x[i] >> y[i];
    }

    long long pozdravi = 0;

    vector<int> indeksi(N);
    for (int i = 0; i < N; i++) {
        indeksi[i] = i;
    }

    sort(indeksi.begin(), indeksi.end(), [&](int a, int b){
        if (x[a] != x[b]) return x[a] < x[b];
        return y[a] < y[b];
    });

    for (int i = 0; i < N; ) {
        int j = i;
        long long parniY = 0, neparniY = 0;
        while(j < N and x[indeksi[j]] == x[indeksi[i]]){
            if((y[indeksi[j]]) == 0){
                parniY++;
            }
            else neparniY++;
            j++;
        }
        pozdravi += parniY * (parniY - 1) / 2;
        pozdravi += neparniY * (neparniY - 1) / 2;
        i = j;
    }

    sort(indeksi.begin(), indeksi.end(), [&](int a, int b){
        if (y[a] != y[b]) {
            return y[a] < y[b];
        }
        return x[a] < x[b];
    });

    for(int i = 0; i < N; ){
        int j = i;
        long long parniX = 0, neparniX = 0;
        while (j < N and y[indeksi[j]] == y[indeksi[i]]) {
            if((x[indeksi[j]]) == 0){
                parniX++;
            }
            else neparniX++;
            j++;
        }
        pozdravi += parniX * (parniX - 1) / 2;
        pozdravi += neparniX * (neparniX - 1) / 2;
        i = j;
    }

    vector<long long> d1(N);
    for(int i = 0; i < N; i++){
        d1[i] = x[i] - y[i];
    }

    sort(indeksi.begin(), indeksi.end(), [&](int a, int b){
        if (d1[a] != d1[b]) {
            return d1[a] < d1[b];
        }
        return x[a] < x[b];
    });

    for(int i = 0; i < N; ){
        int j = i;
        while(j < N and d1[indeksi[j]] == d1[indeksi[i]]){
            j++;
        }
        long long k = j - i;
        pozdravi += k * (k - 1);
        i = j;
    }

    vector<long long> d2(N);
    for(int i = 0; i < N; i++){
        d2[i] = x[i] + y[i];
    }

    sort(indeksi.begin(), indeksi.end(), [&](int a, int b){
        if(d2[a] != d2[b]) {
            return d2[a] < d2[b];
        }
        return x[a] < x[b];
    });

    for(int i = 0; i < N; ){
        int j = i;
        while (j < N and d2[indeksi[j]] == d2[indeksi[i]]){
            j++;
        }
        long long k = j - i;
        pozdravi += k * (k - 1);
        i = j;
    }

    cout << pozdravi << '\n';
    return 0;
}